/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef __FUSION__FIFO_H__
#define __FUSION__FIFO_H__

#include "types.h"
#include "list.h"

typedef struct {
     FusionLink *first;
     FusionLink *last;

     int         count;
} FusionFifo;

void        fusion_fifo_put   (FusionFifo *fifo,
                               FusionLink *link);

FusionLink *fusion_fifo_get   (FusionFifo *fifo);


static inline void
fusion_fifo_reset( FusionFifo *fifo )
{
     fifo->count = 0;
     fifo->first = fifo->last = NULL;
}

#endif 

